# Doctors Hero - Database Activity Log

## Database Overview
**Database Type:** MySQL  
**Laravel Version:** 12.x  
**Migration Path:** `database/migrations/`  
**Seeder Path:** `database/seeders/`  

---

## Database Activity Log

### 2025-08-18 13:11 BD (07:11 UTC)
**Activity:** Documentation Setup  
**Type:** Documentation  
**Description:** Created database activity tracking system  
**Developer:** Assistant  

**Current Database State:**
- **Existing Tables:** 
  - `users` (Laravel Breeze default)
  - `cache` (Laravel default)
  - `jobs` (Laravel default)

**Existing Migrations:**
- `0001_01_01_000000_create_users_table.php`
- `0001_01_01_000001_create_cache_table.php` 
- `0001_01_01_000002_create_jobs_table.php`

---

### Template for Future Database Entries:
```
### YYYY-MM-DD HH:MM BD (HH:MM UTC)
**Activity:** [Create/Update/Delete/Seed]  
**Type:** [Migration/Seeder/Manual Query]  
**File:** `path/to/migration_or_seeder.php`  

**Tables Affected:**
- `table_name` - [Created/Modified/Deleted]

**Columns Added/Modified/Removed:**
- `column_name` (type) - Description
- `column_name` (type) - Description

**Indexes/Constraints:**
- Added: index_name on table_name
- Modified: constraint_name on table_name  
- Removed: old_index on table_name

**Relationships:**
- Added foreign key: table1.column -> table2.column
- Modified relationship: description
- Removed foreign key: description

**Seeded Data:**
- Table: table_name - Number of records, description

**Migration Command:**
```bash
php artisan make:migration migration_name
php artisan migrate
```

**Rollback Info:**
- Can rollback: Yes/No
- Rollback command: `php artisan migrate:rollback --step=X`

**Description:** 
[Detailed explanation of database changes and business logic]

**Developer:** [Name/Role]
```

---

## Database Schema Planning (Future)

### Planned Tables for EMR System:
1. **Users & Authentication**
   - `users` (existing - will extend)
   - `user_roles`
   - `permissions`
   - `role_permissions`

2. **Hospital/Clinic Management**
   - `hospitals`
   - `departments`
   - `hospital_users` (pivot)

3. **Patient Management**
   - `patients`
   - `patient_records`
   - `medical_history`
   - `allergies`
   - `medications`

4. **Appointment System**
   - `appointments`
   - `appointment_types`
   - `schedules`
   - `availability`

5. **Medical Records**
   - `consultations`
   - `prescriptions`
   - `lab_results`
   - `documents`

6. **Billing & Payments**
   - `invoices`
   - `payments`
   - `insurance_claims`

**Note:** Tables will be created incrementally based on user commands and feature requirements.

---

## Quick Commands Reference
```bash
# Create new migration
php artisan make:migration create_table_name --create=table_name

# Create model with migration
php artisan make:model ModelName -m

# Run migrations
php artisan migrate

# Rollback last migration
php artisan migrate:rollback

# Reset all migrations
php artisan migrate:reset

# Create seeder
php artisan make:seeder TableNameSeeder

# Run specific seeder
php artisan db:seed --class=TableNameSeeder

# Run all seeders
php artisan db:seed
```