# Doctors Hero - EMR SaaS Platform

<p align="center">
    <img src="https://laravel.com/img/logomark.min.svg" width="80" alt="Laravel Logo">
</p>

## 🏥 Project Overview

**Doctors Hero** is a comprehensive Electronic Medical Record (EMR) SaaS platform built with Laravel 12. The system provides multi-dashboard appointment management and online booking capabilities for healthcare providers.

### 🎯 Key Features
- **Multi-Role Dashboard System** for different user types
- **Online Appointment Booking** for patients
- **Doctor Appointment Management** system
- **Electronic Medical Records** management
- **Hospital/Clinic Administration** tools

### 👥 User Roles
- **Doctors** - Manage appointments, patient records, prescriptions
- **Receptionist** - Handle bookings, patient check-ins, scheduling
- **Patients** - Book appointments, view medical history, prescriptions
- **Nurses** - Patient care management, medical assistance
- **Hospital Admin** - System administration, staff management

---

## 🛠️ Tech Stack

- **Backend:** Laravel 12.x
- **Authentication:** Laravel Breeze
- **Frontend:** Alpine.js + Tailwind CSS
- **Build Tool:** Vite
- **Database:** MySQL
- **PHP Version:** 8.2+
- **Node Version:** 20.17.0+

---

## 📋 Development Workflow

### 📝 Documentation System
This project maintains detailed activity logs:

- **`CHANGE_CATALOG.md`** - Tracks all development activities with timestamps, file paths, and descriptions
- **`DATABASE_ACTIVITY_LOG.md`** - Tracks all database schema changes and operations

### 🔄 Development Process
1. User provides page designs/HTML code
2. Developer implements with database integration
3. All changes logged in detail with UTC timestamps
4. Team collaboration through Git and documentation

---

## 🚀 Getting Started

### Prerequisites
- PHP 8.2+
- Composer
- Node.js 20.17.0+
- MySQL
- Git

### Installation
```bash
# Clone the repository
git clone https://github.com/orbizen-limited/doctors-hero.git
cd doctors-hero

# Install PHP dependencies
composer install

# Install Node dependencies
npm install

# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate

# Configure your database in .env file
# Then run migrations
php artisan migrate

# Build assets
npm run build

# Start development server
php artisan serve
```

### Development Server
```bash
# Start all services (Laravel, Queue, Logs, Vite)
composer run dev
```

---

## 📖 Project Structure

```
doctors-hero/
├── app/
│   ├── Http/Controllers/     # Application controllers
│   ├── Models/              # Eloquent models
│   └── View/Components/     # Blade components
├── database/
│   ├── migrations/          # Database migrations
│   └── seeders/            # Database seeders
├── resources/
│   ├── views/              # Blade templates
│   ├── js/                 # JavaScript files
│   └── css/                # Stylesheets
├── routes/                 # Application routes
├── CHANGE_CATALOG.md       # Development activity log
└── DATABASE_ACTIVITY_LOG.md # Database changes log
```

---

## 🤝 Contributing

### For Team Members
1. **Always update** `CHANGE_CATALOG.md` when making changes
2. **Log database operations** in `DATABASE_ACTIVITY_LOG.md`
3. **Use UTC timestamps** for all log entries
4. **Include file paths and line numbers** for modifications
5. **Write descriptive commit messages**

### Commit Message Format
```
Type: Brief description

- Detailed change 1
- Detailed change 2
- Database changes (if any)

Files modified:
- path/to/file.ext (lines: X-Y)
```

---

## 📞 Support

For questions or support, please contact the development team or create an issue in this repository.

---

## 📄 License

This project is proprietary software owned by Orbizen Limited.

---

**Last Updated:** 2025-01-18  
**Version:** 1.0.0  
**Status:** In Development