<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Doctor User
        User::create([
            'name' => 'Dr. John Smith',
            'email' => 'doctor@doctorshero.com',
            'password' => Hash::make('password123'),
            'role' => 'doctor',
            'phone' => '+1234567890',
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        // Create Patient User
        User::create([
            'name' => 'Jane Doe',
            'email' => 'patient@doctorshero.com',
            'password' => Hash::make('password123'),
            'role' => 'patient',
            'phone' => '+1234567891',
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        // Create Receptionist User
        User::create([
            'name' => 'Alice Johnson',
            'email' => 'receptionist@doctorshero.com',
            'password' => Hash::make('password123'),
            'role' => 'receptionist',
            'phone' => '+1234567892',
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        // Create Hospital Admin User
        User::create([
            'name' => 'Michael Admin',
            'email' => 'admin@doctorshero.com',
            'password' => Hash::make('password123'),
            'role' => 'hospital_admin',
            'phone' => '+1234567893',
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        // Create Nurse User
        User::create([
            'name' => 'Sarah Wilson',
            'email' => 'nurse@doctorshero.com',
            'password' => Hash::make('password123'),
            'role' => 'nurse',
            'phone' => '+1234567894',
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        // Create Demo User (Default Patient)
        User::create([
            'name' => 'Demo User',
            'email' => 'demo@doctorshero.com',
            'password' => Hash::make('demo123'),
            'role' => 'patient',
            'phone' => '+1234567895',
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        $this->command->info('Test users created successfully!');
        $this->command->info('');
        $this->command->info('=== LOGIN CREDENTIALS ===');
        $this->command->info('Doctor: doctor@doctorshero.com / password123');
        $this->command->info('Patient: patient@doctorshero.com / password123');
        $this->command->info('Receptionist: receptionist@doctorshero.com / password123');
        $this->command->info('Admin: admin@doctorshero.com / password123');
        $this->command->info('Nurse: nurse@doctorshero.com / password123');
        $this->command->info('Demo: demo@doctorshero.com / demo123');
        $this->command->info('========================');
    }
}