import { createApp } from 'vue'
import { createRouter, createWebHistory } from 'vue-router'
import axios from 'axios'

// Configure axios
window.axios = axios
window.axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest'

// Get CSRF token
const token = document.head.querySelector('meta[name="csrf-token"]')
if (token) {
    window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token.content
} else {
    console.error('CSRF token not found: https://laravel.com/docs/csrf#csrf-x-csrf-token')
}

// Import auth components
import AuthLayout from './components/auth/AuthLayout.vue'
import LoginPage from './components/auth/LoginPage.vue'
import SignupPage from './components/auth/SignupPage.vue'

// Auth router configuration
const routes = [
    {
        path: '/login',
        name: 'Login',
        component: LoginPage
    },
    {
        path: '/signup',
        name: 'Signup', 
        component: SignupPage
    },
    {
        path: '/register',
        redirect: '/signup'
    },
    // Default redirect to login
    {
        path: '/',
        redirect: '/login'
    },
    // 404 redirect to login
    {
        path: '/:pathMatch(.*)*',
        redirect: '/login'
    }
]

const router = createRouter({
    history: createWebHistory(),
    routes
})

// Create Vue app
const app = createApp(AuthLayout)
app.use(router)
app.mount('#auth-app')