import { createRouter, createWebHistory } from 'vue-router'
import HomePage from '../components/pages/HomePage.vue'

const routes = [
  {
    path: '/',
    name: 'Home',
    component: HomePage
  },
  {
    path: '/about',
    name: 'About',
    component: () => import('../components/pages/AboutPage.vue')
  },
  {
    path: '/services',
    name: 'Services',
    component: () => import('../components/pages/ServicesPage.vue')
  },
  {
    path: '/doctors',
    name: 'Doctors',
    component: () => import('../components/pages/DoctorsPage.vue')
  },
  {
    path: '/appointment',
    name: 'Appointment',
    component: () => import('../components/pages/AppointmentPage.vue')
  },
  {
    path: '/blog',
    name: 'Blog',
    component: () => import('../components/pages/BlogPage.vue')
  },
  {
    path: '/contact',
    name: 'Contact',
    component: () => import('../components/pages/ContactPage.vue')
  },
  {
    path: '/login',
    name: 'Login',
    component: () => import('../components/pages/LoginPage.vue')
  },
  {
    path: '/404',
    name: 'NotFound',
    component: () => import('../components/pages/NotFound.vue')
  },
  {
    path: '/:pathMatch(.*)*',
    redirect: '/404'
  }
]

const router = createRouter({
  history: createWebHistory(),
  routes
})

export default router