<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if ($errors->any())
    <meta name="validation-errors" content="{{ json_encode($errors->all()) }}">
    @endif

    <meta name="description" content="Doctors Hero - Secure Login and Registration">
    <meta name="author" content="Doctors Hero">

    <title>{{ config('app.name', 'Doctors Hero') }} - Authentication</title>

    <!-- Favicon -->
    <link href="{{ asset('auth/images/favicon_4.png') }}" rel="icon">

    <!-- Google Web Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600&display=swap" rel="stylesheet">

    <!-- Font Awesome 5 Free -->
    <link href="https://use.fontawesome.com/releases/v5.15.1/css/all.css" integrity="sha384-vp86vTRFVJgpjF9jiIGPEEqYqlDwgyBgEF109VFjmqGmIY/Y4HV4d3Gp2irVfcrp" crossorigin="anonymous" rel="stylesheet">

    <!-- Auth Template CSS files -->
    <link href="{{ asset('auth/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('auth/css/styles.css') }}" rel="stylesheet">
    <link href="{{ asset('auth/css/colors/turquoise.css') }}" rel="stylesheet">

    <!-- Vite CSS -->
    @vite(['resources/css/app.css', 'resources/js/auth.js'])
</head>
<body>
    <!-- Preloader -->
    <div id="nm-preloader" class="nm-aic nm-vh-md-100">
        <div class="nm-ripple">
            <div></div>
            <div></div>
        </div>
    </div>

    <!-- Vue.js Auth App -->
    <div id="auth-app"></div>

    <!-- Auth Template JS files -->
    <script src="{{ asset('auth/js/jquery-3.6.0.min.js') }}"></script>
    <script src="{{ asset('auth/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('auth/js/script.js') }}"></script>
</body>
</html>