<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Doctors Hero') }} - Dashboard</title>

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Dashboard CSS -->
    <link href="{{ asset('dashboard/css/dashboard.css') }}" rel="stylesheet">
    
    <!-- Vite CSS/JS -->
    @vite(['resources/css/app.css', 'resources/js/dashboard.js'])
</head>
<body class="dashboard-body">
    <!-- Vue.js Dashboard App -->
    <div id="dashboard-app"></div>

    <!-- Dashboard JS -->
    <script src="{{ asset('dashboard/js/dashboard.js') }}"></script>
    
    <!-- Pass user data to Vue via meta tags -->
    <meta name="dashboard-user" content="{{ base64_encode(json_encode(auth()->user())) }}">
    <meta name="user-role" content="{{ auth()->user()->role ?? 'patient' }}">
    
    <!-- Initialize dashboard data -->
    <script>
        // Parse user data from meta tags
        const userMeta = document.querySelector('meta[name="dashboard-user"]');
        const roleMeta = document.querySelector('meta[name="user-role"]');
        
        window.dashboardUser = userMeta ? JSON.parse(atob(userMeta.content)) : null;
        window.userRole = roleMeta ? roleMeta.content : 'patient';
    </script>
</body>
</html>