<?php

use App\Http\Controllers\AiChatController;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Route;

// Authentication API Routes
Route::post('/login', [LoginController::class, 'login'])->name('api.login');
Route::post('/register', [LoginController::class, 'register'])->name('api.register');
Route::post('/logout', [LoginController::class, 'logout'])->middleware('auth:sanctum')->name('api.logout');
Route::get('/user', [LoginController::class, 'user'])->middleware('auth:sanctum')->name('api.user');

// AI Chat API Routes
Route::post('/ai-chat', [AiChatController::class, 'sendMessage'])->name('ai.chat');